package gov.va.med.mhv.mrp.data.model;

import java.io.Serializable;
import javax.persistence.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Entity
@NamedQuery(name="MyGoals.findAll", query="SELECT m FROM MyGoals m")
public class MyGoals implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="GOAL_ID")
	private Long goalId;

	private String category;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="COMPLETED_DATE")
	private Calendar completedDate;

	@Column(name="COMPLETION_TYPE")
	private Integer completionType;

	private String description;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="END_DATE")
	private Date endDate;

	@Column(name="GOAL_NAME")
	private String goalName;

	@Version
	private Integer oplock;

	@Column(name="PRIORITY_TYPE")
	private Integer priorityType;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="START_DATE")
	private Date startDate;

	private Integer status;

	@Column(name="STATUS_MESSAGE")
	private Integer statusMessage;

	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;

	//bi-directional many-to-one association to MyGoalsExtensions
	@OneToMany(mappedBy="myGoal", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
	private List<MyGoalsExtensions> myGoalsExtensions = new ArrayList<MyGoalsExtensions>();

	public MyGoals() {
	}

	public Long getGoalId() {
		return this.goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public String getCategory() {
		return this.category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public Calendar getCompletedDate() {
		return this.completedDate;
	}

	public void setCompletedDate(Calendar completedDate) {
		this.completedDate = completedDate;
	}

	public Integer getCompletionType() {
		return this.completionType;
	}

	public void setCompletionType(Integer completionType) {
		this.completionType = completionType;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getGoalName() {
		return this.goalName;
	}

	public void setGoalName(String goalName) {
		this.goalName = goalName;
	}

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getPriorityType() {
		return this.priorityType;
	}

	public void setPriorityType(Integer priorityType) {
		this.priorityType = priorityType;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Integer getStatus() {
		return this.status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatusMessage() {
		return this.statusMessage;
	}

	public void setStatusMessage(Integer statusMessage) {
		this.statusMessage = statusMessage;
	}

	public Long getUserProfileId() {
		return this.userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public List<MyGoalsExtensions> getMyGoalsExtensions() {
		return this.myGoalsExtensions;
	}

	public void setMyGoalsExtensions(List<MyGoalsExtensions> myGoalsExtensions) {
		this.myGoalsExtensions = myGoalsExtensions;
	}

	public MyGoalsExtensions addMyGoalsExtension(MyGoalsExtensions myGoalsExtension) {
		if (this.myGoalsExtensions == null) {
			setMyGoalsExtensions(new ArrayList<MyGoalsExtensions>());
		}
		getMyGoalsExtensions().add(myGoalsExtension);		
		myGoalsExtension.setMyGoal(this);

		return myGoalsExtension;
	}

	public MyGoalsExtensions removeMyGoalsExtension(MyGoalsExtensions myGoalsExtension) {
		getMyGoalsExtensions().remove(myGoalsExtension);
		myGoalsExtension.setMyGoal(null);

		return myGoalsExtension;
	}

}